
import oscP5.*;
import netP5.*;

import controlP5.*;
ControlP5 controlP5;

OscP5 oscP5;
NetAddress myRemoteLocation;

int ws;
int hs;

int typeV=3;
int nbMembresMax=10;
int typeMemV;
float[] tmpM=new float[nbMembresMax];

// general
float tailleMax=10;
int pays=0;

//communs aux monstres
float xV=0.5;
float tailleV=1;

//son1
float lTotalV;
float AltCilsV;
float AltTentaculesV;
float AltBrasV;
float AltYeuxAV;

//son2
float BgtCorpsV=1;
int BnbJambesV=1;
float BltJambesV=1;
float BltYeuxV=1;
int BnbBecsV=1;
float[] tB=new float[nbMembresMax];

//son3
float gTotalV;
float[] lPics =new float[nbMembresMax];
float[] lQueues =new float[nbMembresMax];
float[] lAiles =new float[nbMembresMax];
float[] lYeuxC =new float[nbMembresMax];

void setup() {
  size(400,400);
  controlP5 = new ControlP5(this);
  oscP5 = new OscP5(this,12000);
  myRemoteLocation = new NetAddress("127.0.0.1",12001);
  sendGeneral();

  ws=0;
  hs=1;
  controlP5.addSlider("type",1,3,typeV,hs*50,++ws*40,20,20);
  controlP5.addSlider("x",0,1,xV,hs*50,++ws*40,20,20);
  controlP5.addSlider("taille",0,tailleMax,tailleV,hs*50,++ws*40,20,20);
  controlP5.addSlider("pays",0,2,pays,hs*50,++ws*40,20,20);  
  colP();
  controlP5.addSlider("BgtCorps",0,500,BgtCorpsV,hs*50,++ws*40,20,20);
  controlP5.addSlider("BnbJambes",0,10,BnbJambesV,hs*50,++ws*40,20,20);
  controlP5.addSlider("BltJambes",0,1500,BltJambesV,hs*50,++ws*40,20,20);  
  controlP5.addSlider("BltYeux",0,1500,BltYeuxV,hs*50,++ws*40,20,20);
  controlP5.addSlider("BnbBecs",0,10,BnbBecsV,hs*50,++ws*40,20,20);
  controlP5.addSlider("gTotal",0,4500,gTotalV,hs*50,++ws*40,20,20);  
  colP();
  controlP5.addSlider("lTotal",0,4500,lTotalV,hs*50,++ws*40,20,20);
  controlP5.addSlider("AltCils",0,1500,AltCilsV,hs*50,++ws*40,20,20);
  controlP5.addSlider("AltTent",0,1500,AltTentaculesV,hs*50,++ws*40,20,20);
  controlP5.addSlider("AltBras",0,1500,AltBrasV,hs*50,++ws*40,20,20);
  controlP5.addSlider("AltYeuxA",0,1500,AltYeuxAV,hs*50,++ws*40,20,20);
  colP();  
  controlP5.addSlider("M1",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M2",0,150,0,hs*50,++ws*40,20,20);  
  controlP5.addSlider("M3",0,150,0,hs*50,++ws*40,20,20);  
  controlP5.addSlider("M4",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M5",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("typeMem",0,5,0,hs*50,++ws*40,20,20);
  colP();  
  controlP5.addSlider("M6",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M7",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M8",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M9",0,150,0,hs*50,++ws*40,20,20);
  controlP5.addSlider("M10",0,150,0,hs*50,++ws*40,20,20);
  colP();
  controlP5.addBang("lS",300,++ws*50,30,30);
  controlP5.controller("lS").setLabel("lance le son");
  controlP5.addBang("lSPB",300,++ws*50,30,30);
  controlP5.controller("lSPB").setLabel("lance le son pasB");
  controlP5.addBang("alea",300,++ws*50,30,30);
  controlP5.controller("alea").setLabel("aleatoire");
  controlP5.addBang("sendGeneral",300,++ws*50,30,30);
  controlP5.controller("sendGeneral").setLabel("general");
}

void draw() {
  background(0);
}

void alea() {
  typeV=floor(random(3))+1;
  xV=random(1);
  tailleV=random(tailleMax);
  BgtCorpsV=random(500);
  BnbJambesV=floor(random(10));
  BltJambesV=random(1500);
  BltYeuxV=random(1500);
  BnbBecsV=floor(random(10));
  gTotalV=random(4500);
  lTotalV=random(4500);
  AltCilsV=random(1500);
  AltTentaculesV=random(1500);
  AltBrasV=random(1500);
  AltYeuxAV=random(1500);
  for (int i=0;i<nbMembresMax;i++) {
    tB[i]=random(150);
    lPics[i]=random(150);
    lQueues[i]=random(150);
    lAiles[i]=random(150);
    lYeuxC[i]=random(150);
  }
  controlP5.controller("type").setValue(typeV);
  controlP5.controller("x").setValue(xV);
  controlP5.controller("taille").setValue(tailleV);
  controlP5.controller("BgtCorps").setValue(BgtCorpsV);
  controlP5.controller("BnbJambes").setValue(BnbJambesV);
  controlP5.controller("BltJambes").setValue(BltJambesV);
  controlP5.controller("BltYeux").setValue(BltYeuxV);
  controlP5.controller("BnbBecs").setValue(BnbBecsV);
  controlP5.controller("gTotal").setValue(gTotalV);
  controlP5.controller("lTotal").setValue(lTotalV);
  controlP5.controller("AltCils").setValue(AltCilsV);
  controlP5.controller("AltTent").setValue(AltTentaculesV);
  controlP5.controller("AltBras").setValue(AltBrasV);
  controlP5.controller("AltYeuxA").setValue(AltYeuxAV);
}

void gTotal(float value) {
  gTotalV=value;
}

void okM(int i) {
  if (typeMemV==0) {
    tB[i]=tmpM[i];
  }
  if (typeMemV==1) {
    lPics[i]=tmpM[i];
  }   
  if (typeMemV==2) {
    lQueues[i]=tmpM[i];
  }    
  if (typeMemV==3) {
    lAiles[i]=tmpM[i];
  }     
  if (typeMemV==4) {
    lYeuxC[i]=tmpM[i];
  }
}

void typeMem(int value) {
  typeMemV=value;
  if (typeMemV==0) {
    for (int i=0;i<nbMembresMax;i++) {
      tmpM[i]=tB[i];
    }
  }
  if (typeMemV==1) {
    for (int i=0;i<nbMembresMax;i++) {
      tmpM[i]=lPics[i];
    }
  }   
  if (typeMemV==2) {
    for (int i=0;i<nbMembresMax;i++) {
      tmpM[i]=lQueues[i];
    }
  }    
  if (typeMemV==3) {
    for (int i=0;i<nbMembresMax;i++) {
      tmpM[i]=lAiles[i];
    }
  }     
  if (typeMemV==4) {
    for (int i=0;i<nbMembresMax;i++) {
      tmpM[i]=lYeuxC[i];
    }
  }
  controlP5.controller("M1").setValue(tmpM[0]);
  controlP5.controller("M2").setValue(tmpM[1]);
  controlP5.controller("M3").setValue(tmpM[2]);
  controlP5.controller("M4").setValue(tmpM[3]);
  controlP5.controller("M5").setValue(tmpM[4]);
  controlP5.controller("M6").setValue(tmpM[5]);
  controlP5.controller("M7").setValue(tmpM[6]);
  controlP5.controller("M8").setValue(tmpM[7]);
  controlP5.controller("M9").setValue(tmpM[8]);
  controlP5.controller("M10").setValue(tmpM[9]);  
}

void type(int value) {
  typeV=value;
}

void x(float value) {
  xV=value;
}

void taille(float value) {
  tailleV=value;
}

void pays(int value) {
  pays=value;
}

void BgtCorps(float value) {
  BgtCorpsV=value;
}

void BnbJambes(int value) {
  BnbJambesV=value;
}

void BltJambes(float value) {
  BltJambesV=value;
}

void BltYeux(float value) {
  BltYeuxV=value;
}

void BnbBecs(int value) {
  BnbBecsV=value;
}

void lTotal(float value) {
  lTotalV=value;
}
void AltCils(float value) {
  AltCilsV=value;
}
void AltTent(float value) {
  AltTentaculesV=value;
}
void AltBras(float value) {
  AltBrasV=value;
}
void AltYeuxA(float value) {
  AltYeuxAV=value;
}

void M1(int value) {
  tmpM[0]=value;
  okM(0);
}
void M2(int value) {
  tmpM[1]=value;
  okM(1);  
}
void M3(int value) {
  tmpM[2]=value;
  okM(2);  
}
void M4(int value) {
  tmpM[3]=value;
  okM(3);  
}
void M5(int value) {
  tmpM[4]=value;
  okM(4);  
}
void M6(int value) {
  tmpM[5]=value;
  okM(5);
}
void M7(int value) {
  tmpM[6]=value;
  okM(6);  
}
void M8(int value) {
  tmpM[7]=value;
  okM(7);
}
void M9(int value) {
  tmpM[8]=value;
  okM(8);  
}
void M10(int value) {
  tmpM[9]=value;
  okM(9);  
}

void colP() {
  hs++;
  ws=0;
}

void lS() {
  if (typeV==1) {
    OscMessage myOscMessage = new OscMessage("/sonA");
    myOscMessage.add((float)xV);
    myOscMessage.add((float)tailleV);
    myOscMessage.add((float)lTotalV);
    myOscMessage.add((float)AltCilsV);
    myOscMessage.add((float)AltTentaculesV);
    myOscMessage.add((float)AltBrasV);
    myOscMessage.add((float)AltYeuxAV);
    oscP5.send(myOscMessage, myRemoteLocation);
  }
  if (typeV==2) {
    OscMessage myOscMessage = new OscMessage("/sonB");
    myOscMessage.add((float)xV);
    myOscMessage.add((float)tailleV);
    myOscMessage.add((float)BgtCorpsV);
    myOscMessage.add((int)BnbJambesV);
    myOscMessage.add((float)BltJambesV);    
    myOscMessage.add((float)BltYeuxV);
    for (int i=0;i<10;i++) {
      myOscMessage.add((float)tB[i]);
    }
    myOscMessage.add((int)BnbBecsV);    
    oscP5.send(myOscMessage, myRemoteLocation);
  }
  if (typeV==3) {
    OscMessage myOscMessage = new OscMessage("/sonC");
    myOscMessage.add((float)xV);
    myOscMessage.add((float)tailleV);
    myOscMessage.add((float)gTotalV);
    for (int i=0;i<10;i++) {
      myOscMessage.add((float)lPics[i]);
    }
    for (int i=0;i<10;i++) {
      myOscMessage.add((float)lQueues[i]);
    }
    for (int i=0;i<10;i++) {
      myOscMessage.add((float)lAiles[i]);
    }
    for (int i=0;i<10;i++) {
      myOscMessage.add((float)lYeuxC[i]);
    }
    oscP5.send(myOscMessage, myRemoteLocation);
  }
}

void lSPB() {
  OscMessage myOscMessage = new OscMessage("/pasB");
  myOscMessage.add((float)xV);
  oscP5.send(myOscMessage, myRemoteLocation);
}

void sendGeneral() {
  //general :
  //camx
  OscMessage myOscMessage = new OscMessage("/general");
  myOscMessage.add(width);
  myOscMessage.add(height);
  myOscMessage.add(tailleMax);
  myOscMessage.add(pays);
  oscP5.send(myOscMessage, myRemoteLocation);
}
